﻿* Encoding: UTF-8.
**************************************************************************************************************************************************************************************************************************
*            IBM SPSS syntax code to extract various statistics from the MPLUS CFA outputs with PISA's international calibration samples           *
**************************************************************************************************************************************************************************************************************************
* (c) Pawel Piotr Skuza (04/2016)        *
* pawel.skuza@flinders.edu.au                 *
* Feel free to use or modify this code, but acknowledge the author using below citation:
* Skuza, P. P. (2016). IBM SPSS syntax code to extract various statistics from the MPLUS CFA outputs with PISA's international calibration samples [Source code] (Version 1). Adelaide, Australia: Flinders University.  *
**************************************************************************************************************************************************************************************************************************.
***** !!!!! (1). 
***** BELOW SHORT MACROS HAVE TO BE ALWAYS RUN FIRST WHEN FILE IS RE_OPENED.
******************** FOLDERS LISTED IN BELOW LINES HAVE TO CREATED BEFORE THE SYNTAX CAN BE RUN.
******************** CODE INCLUDES LINE 40 WHICH USES THE FOLDER YET DOES NOT REFER TO THE MACRO. 
******************** IF BELOW FOLDER NAME IS TO BE CHANGED THIS LINE HAS TO MANUALLY ADJUSTED.
******************** EACH WAVE HAS ITS OWN SUBFOLDER IN MAIN, RC AND WARNINGS STARTING WITH YEAR_DOMAIN_NAME OF FOLDER (2000_R_MAIN or 2012_M_WARNINGS).

***** !!!!! (2). 
***** REFERENCE FOLDERS - MACROS TO BE CALLED FROM WITHIN ANOTHER MACRO.

DEFINE  !filedirRC()  	'C:\Temp\! INTERNATIONAL CALIBRATIONS\3_MPLUS OUTPUT EXTRACTION\RC\'		!ENDDEFINE. 
DEFINE  !filedirMAIN()  	'C:\Temp\! INTERNATIONAL CALIBRATIONS\3_MPLUS OUTPUT EXTRACTION\MAIN\'		!ENDDEFINE. 
DEFINE  !filedirWARN()  	'C:\Temp\! INTERNATIONAL CALIBRATIONS\3_MPLUS OUTPUT EXTRACTION\WARNINGS\'		!ENDDEFINE. 
DEFINE  !filedirQgraph()  	'C:\Temp\! INTERNATIONAL CALIBRATIONS\4_QGraphs\'		!ENDDEFINE. 

************************ DIFFERENCE BETWEEN PAIR OF ITEMS FOR STRING VARIABLES  - MACRO TO BE CALLED FROM WITHIN ANOTHER MACRO.

*MACRO DEFINITION.

DEFINE STRING_DIFFERENCE (Variables= !charend('/') ).

	   !DO !M !In (!Variables).

MISSING VALUES !CONCAT(!M,'_A') !CONCAT(!M,'_B') ('').

COMPUTE !CONCAT(!M,'_AB_DIF')=0.
EXECUTE.
IF  ( !CONCAT(!M,'_A') = !CONCAT(!M,'_B'))  !CONCAT(!M,'_AB_DIF')=1.
EXECUTE.
IF  ( !CONCAT(!M,'_A') = '' |  !CONCAT(!M,'_B') = '')  !CONCAT(!M,'_AB_DIF')=9.
EXECUTE.
FORMATS  !CONCAT(!M,'_AB_DIF') (F1.0).
VALUE LABELS  !CONCAT(!M,'_AB_DIF')
"0" "NOT AGREE"
"1" "AGREE"
"9" "MISSING".
MISSING VALUES !CONCAT(!M,'_AB_DIF') (9).

	   !DOEnd.
!ENDDEFINE.

***** !!!!! (3).
***** AGGREGATE MPLUS OUTPUT FILES INTO 15 '_ALL' DATASETS.
****** MANUAL STEPS TO PREPARE TXT FILE BEFORE BELOW MACRO COULD BE RUN.

******************** COPY ALL MPLUS FILES FROM EACH WAVE/DOMAIN - *.OUT INTO RELEVANT FOLDER, FOR EXAMPLE, 
C:\TEMP\! INTERNATIONAL CALIBRATIONS\3_MPLUS OUTPUT EXTRACTION\MAIN/2000_M_MAIN. 
******************** START EXCEL AND OPEN EACH OF THE FILES, FOR EXAMPLE, Page_ICM2000M.out IN EXCEL FILE AS DELIMITED WITH SPACE.
******************** SAVE EACH OF THE EXCEL FILES AS TABLE DELIMITED IN NAMING CONENTION OF FOR EXAMPLE 2000_M_TAB.TXT.
******************** REPEAT ABOVE TWO POINTS FOR ALL 15 WAVES/DOMAINS.

DEFINE AGG_MPLUS (	WAVE_CD= !charend('/') ).

* LOOP TO GET ALL LISTED IN MACRO CALL FILES.

	   !DO !I !In(!wave_cd).

DATASET CLOSE ALL.
NEW FILE.

GET DATA  /TYPE=TXT
  /FILE=!filedirMAIN + !I + !QUOTE('_MAIN\') +!I + !QUOTE('_TAB.txt') 
  /DELCASE=LINE
  /DELIMITERS="\t"
  /ARRANGEMENT=DELIMITED
  /FIRSTCASE=1
  /IMPORTCASE=ALL
  /VARIABLES=
  V1 A16
  V2 A14
  V3 A12
  V4 A10
  V5 A13
  V6 A10
  V7 A8
  V8 A12
  V9 A10
  V10 A10
  V11 A10
  V12 A10
  V13 A10
  V14 A10
  V15 A10
  V16 A10
  V17 A10
  V18 A10
  V19 A10
  V20 A10
  V21 A10
  V22 A10.
CACHE.
EXECUTE.

* SYNAX TO EXTRACT YEAR, DOMAIN. MPLUS TITLES HAVE TO BE IN FORMAT OF FOR EXAMPLE 2012_M_INT.

COMPUTE ID1=$CASENUM.
EXECUTE.
FORMATS ID1 (F8.0).

STRING  ID2 (A8).
COMPUTE ID2=STRUNC(V3,6).
EXECUTE.

STRING  ID3 (A8).
COMPUTE ID3=!I.
EXECUTE.

STRING  CNT (A33).
IF  (ID2=ID3) CNT=STRUNC(V3,10).
IF  (ID2<>ID3) CNT=LAG(CNT).
EXECUTE.

RENAME VARIABLES (CNT=CNT_1).

STRING  YEAR (A4).
COMPUTE YEAR=CHAR.SUBSTR(CNT_1,1,4).
EXECUTE.

STRING  DOMAIN (A1).
COMPUTE DOMAIN=CHAR.SUBSTR(CNT_1,6,1).
EXECUTE.

STRING  COUNTRY (A3).
COMPUTE COUNTRY=CHAR.SUBSTR(CNT_1,8,3).
EXECUTE.

STRING  CNT (A10).
COMPUTE CNT=STRUNC(CNT_1,10).
EXECUTE.

* SYNTAX to extract sample size used in Mplus.

STRING  Sample (A10).
IF  (V3="observations") Sample=V4.
IF  (V3<>"observations") Sample=LAG(Sample).
EXECUTE.

ALTER TYPE  Sample (F8.0).

* SYNTAX to extract Number of items used in Mplus. 

STRING  Items (A10).
EXECUTE.
IF  (V3="dependent") Items=V5.
IF  (V3<>"dependent") Items=LAG(Items).
EXECUTE.

ALTER TYPE  Items (F8.0).

* Syntax to create variable to flag MPLUS cells with the residual correlations.
COMPUTE RC=0.
EXECUTE.

IF  (V2="Residuals" AND V5="Correlations") RC=1.
EXECUTE.

IF (V2<>"Residuals" AND V5<>"Correlations" AND V5<>"CATEGORICAL") RC=LAG(RC).
EXECUTE.

RECODE RC (SYSMIS=0).
EXECUTE.

FORMATS RC (F1.0).

* SYNTAX TO SELECT Modification Indicies subset. 

COMPUTE MI=0.
EXECUTE.

IF  (V2="WITH") MI=1.
EXECUTE.

FORMATS MI (F1.0).

* SYNTAX TO SELECT Warnings subset. 

COMPUTE Warning=0.
EXECUTE.
IF  ((V2="WARNING:" & V4~="LATENT") | V2="COMPUTATIONAL"  | (V2="PROBLEM" & V4="VARIABLE") ) Warning=1.
EXECUTE.
FORMATS Warning (F1.0).
VALUE LABELS Warning
"0" "NONE"
"1" "WARNING".

COMPUTE TYPE_Warning=0.
EXECUTE.
IF  (Warning=1 & V4="SAMPLE" & (CHAR.LENGTH(V11)=1 | CHAR.LENGTH(V11)=5)) TYPE_Warning=1.
EXECUTE.
IF  (Warning=1 & V4="SAMPLE" & (CHAR.LENGTH(V11)=2 | CHAR.LENGTH(V11)=6)) TYPE_Warning=2.
EXECUTE.
IF  (Warning=1 & V12="EMPTY") TYPE_Warning=3.
EXECUTE.
IF  (Warning=1 & V2="COMPUTATIONAL") TYPE_Warning=4.
EXECUTE.
IF  (Warning=1 & V2="PROBLEM") TYPE_Warning=5.
EXECUTE.

VALUE LABELS TYPE_Warning
"1" "CORRELATION CLOSE TO PERFECT 1"
"2" "CORRELATION CLOSE TO PERFECT -1"
"3" "EMPTY CELL"
"4" "COMPUTATIONAL PROBLEMS"
"5" "COVARIANCE MATRIX NOT POSITIVE".
FORMATS TYPE_Warning (F1.0).

SAVE OUTFILE=!filedirMAIN + !I + !QUOTE('_MAIN\') +!I + !QUOTE('_ALL.sav') 
  /DROP ID3
  /COMPRESSED.

DATASET CLOSE ALL.

GET
  FILE=!filedirMAIN + !I + !QUOTE('_MAIN\') +!I + !QUOTE('_ALL.sav').

AGGREGATE
  /OUTFILE=!filedirMAIN + !I + !QUOTE('_MAIN\') +!I + !QUOTE('_ITEMS USED BY COUNTRIES.sav') 
  /BREAK=CNT
  /Sample_last=LAST(Sample) 
  /Items_last=LAST(Items).

	   !DOEnd.

!ENDDEFINE.



************************ RC MACRO THAT DEFINES ALL 15 FILES WITH THE RESIDUAL CORRELATIONS AND PRODUCES 15 SEPARATE DESCRIPTIVE OUTPUTS.

DEFINE RC15FILES (	WAVE_CD= !charend('/') ).

***** LOOP STARTS HERE - USES THE DATAFILES FROM ALL MPLUS OUTPUTS AGGREGATED TOGETHER.

	!DO !I !In(!wave_cd).

DATASET CLOSE ALL.

GET
  FILE=!filedirMAIN + !I + !QUOTE('_MAIN\') +!I + !QUOTE('_ALL.sav').

***** GET FILES FOR WHICH MPLUS DID NOT CONVERGE.

FILTER OFF.
USE ALL.
SELECT IF (V2="Elapsed").
EXECUTE.

SAVE OUTFILE=!filedirRC + !I + !QUOTE('_LID\') +!I + !QUOTE('_CNT_ELAPSED_TIME.sav')
  /DROP=V1 V5 V6 V7 V8 V9 V10 V11 V12 V13 V14 V15 V16 V17 V18 V19 V20 V21 V22 ID1 ID2 RC MI Warning TYPE_Warning
  /COMPRESSED.

DATASET CLOSE ALL.

GET
  FILE=!filedirMAIN + !I + !QUOTE('_MAIN\') +!I + !QUOTE('_ALL.sav').

***** RESIDUAL CORRELATIONS EXTRACTION FROM AGGREGATED MPLUS FILES.

FILTER OFF.
USE ALL.
SELECT IF (RC=1).
EXECUTE.

SAVE OUTFILE=!filedirRC + !I + !QUOTE('_LID\') +!I + !QUOTE('_LID_RC.sav') 
  /DROP=ID2 MI TYPE_Warning Warning
  /COMPRESSED.

DATASET CLOSE ALL.

GET
  FILE=!filedirRC + !I + !QUOTE('_LID\') +!I + !QUOTE('_LID_RC.sav').

***** TO CONVERT MPLUS TRUNCATED MATRIX OF RESIDUAL CORRELATIONS - STEP 1 - MATCH ROW AND COLUMN ITEMS' NAMES.

* FIRST COLUMN.
STRING  ITEM_1 (A8).
IF  (V2="________") ITEM_1=LAG(V2).
EXECUTE.

IF  (V2 ~= "________") ITEM_1=LAG(ITEM_1).
EXECUTE.

* SECOND COLUMN.
STRING  ITEM_2 (A8).
IF  (V2="________") ITEM_2=LAG(V3).
EXECUTE.

IF  (V2 ~= "________") ITEM_2=LAG(ITEM_2).
EXECUTE.

* THIRD COLUMN.
STRING  ITEM_3 (A8).
IF  (V2="________") ITEM_3=LAG(V4).
EXECUTE.

IF  (V2 ~= "________") ITEM_3=LAG(ITEM_3).
EXECUTE.

* FOURTH COLUMN.
STRING  ITEM_4 (A8).
IF  (V2="________") ITEM_4=LAG(V5).
EXECUTE.

IF  (V2 ~= "________") ITEM_4=LAG(ITEM_4).
EXECUTE.

* FIFTH COLUMN.
STRING  ITEM_5 (A8).
IF  (V2="________") ITEM_5=LAG(V6).
EXECUTE.

IF  (V2 ~= "________") ITEM_5=LAG(ITEM_5).
EXECUTE.

SAVE OUTFILE=!filedirRC + !I + !QUOTE('_LID\') +!I + !QUOTE('_LID_RC_STEP1.sav') 
  /COMPRESSED.

***** TO CONVERT MPLUS TRUNCATED MATRIX OF RESIDUAL CORRELATIONS - STEP 2  - SELECT ONLY CELLS WIHT RC DATA.

FILTER OFF.
USE ALL.
SELECT IF (STRUNC(V3,1)="0" | STRUNC(V3,1)="1" | STRUNC(V3,2)="-1" | STRUNC(V3,2)="-0").
EXECUTE.

SAVE OUTFILE=!filedirRC + !I + !QUOTE('_LID\') +!I + !QUOTE('_LID_RC_STEP2.sav')
/ DROP RC V1 V8 V9 V10 V11 V12 V13 V14 V15 V16 V17 V18 V19 V20 V21 V22
  /COMPRESSED.

DATASET CLOSE ALL.

GET
  FILE=!filedirRC + !I + !QUOTE('_LID\') +!I + !QUOTE('_LID_RC_STEP2.sav').

*****  TO CONVERT MPLUS TRUNCATED MATRIX OF RESIDUAL CORRELATIONS - STEP 3 - TRANSFORM FROM WIDE TO LONG FORMAT.

VARSTOCASES
  /ID=id
  /MAKE ITEM_A FROM ITEM_1 ITEM_2 ITEM_3 ITEM_4 ITEM_5
  /MAKE RC_VALUE FROM V3 V4 V5 V6 V7
  /INDEX=Index1(ITEM_A) 
  /KEEP=V2 ID1 CNT Sample Items
  /NULL=KEEP.

SAVE OUTFILE=!filedirRC + !I + !QUOTE('_LID\') +!I + !QUOTE('_LID_RC_STEP3.sav')
  /COMPRESSED.

DATASET CLOSE ALL.

GET
  FILE=!filedirRC + !I + !QUOTE('_LID\') +!I + !QUOTE('_LID_RC_STEP3.sav').

*****  TO ADD TESTLET IDENTIFIERS AND REMOVE REDUNDANT DATA ROWS.

STRING  TESTLET_1 (A8).
COMPUTE TESTLET_1=STRUNC(V2,4).
EXECUTE.

STRING  TESTLET_2 (A8).
COMPUTE TESTLET_2=STRUNC(ITEM_A,4).
EXECUTE.

COMPUTE TESTLET=0.
EXECUTE.
IF  (TESTLET_1=TESTLET_2) TESTLET=1.
EXECUTE.

FORMATS TESTLET (F1.0).
VALUE LABELS TESTLET 
 "0 "  "OUTSIDE TESTLET"
 "1" "WITHIN TESTLET".

ALTER TYPE  RC_Value (F8.2).
VARIABLE LEVEL RC_VALUE (SCALE).
EXECUTE.

VARIABLE LEVEL Sample (SCALE).
EXECUTE.

VARIABLE LABELS RC_VALUE Residual Correlation.

RENAME VARIABLES (CNT=CNT_1).

STRING  YEAR (A4).
COMPUTE YEAR=CHAR.SUBSTR(CNT_1,1,4).
EXECUTE.

STRING  DOMAIN (A1).
COMPUTE DOMAIN=CHAR.SUBSTR(CNT_1,6,1).
EXECUTE.

STRING  COUNTRY (A3).
COMPUTE COUNTRY=CHAR.SUBSTR(CNT_1,8,3).
EXECUTE.

STRING  CNT (A10).
COMPUTE CNT=STRUNC(CNT_1,10).
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (NVALID(RC_VALUE)=1).
EXECUTE.

*****  BELOW STEP REDUNDANT FOR INTERNATIONAL CALIBRATION SAMPLES ANALYSES.
*****  TO CONVERT MPLUS TRUNCATED MATRIX OF RESIDUAL CORRELATIONS - STEP 4 - CALL THE MACRO INSIDE OTHER MACRO REMOVE UNWANTED COUNTRIES. 

COMPUTE ORDER_ID=$CASENUM.
EXECUTE.

FORMATS ORDER_ID (F12.0).

RENAME VARIABLES (V2=ITEM_B).

VARIABLE LABELS TESTLET_1 Testlet Identifier.

STRING  SPACE (A1).
COMPUTE SPACE="_".
EXECUTE.

STRING  Pair_Identifier (A20).
COMPUTE Pair_Identifier=CONCAT(ITEM_B,SPACE,ITEM_A).
EXECUTE.

***************** SPECIAL TREATMENT OF PISA 2000 WHEN RC ARE OBTAINED FROM 2 MPLUS RUNS. TAKING AVERAGES OF RC AND PRODUCING ICC TO ARGUE LITTLE VARIABILITY ON LEVEL1.

      AGGREGATE
        /OUTFILE=* MODE=ADDVARIABLES
        /BREAK=Pair_Identifier
        /N_BREAK=N.

      USE ALL.
      COMPUTE filter_$=(N_BREAK > 1).
      VARIABLE LABELS filter_$ 'N_BREAK > 1 (FILTER)'.
      VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
      FORMATS filter_$ (f1.0).
      FILTER BY filter_$.
      EXECUTE.

      MIXED RC_VALUE
        /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
          ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
        /FIXED=| SSTYPE(3)
        /METHOD=REML
        /PRINT=SOLUTION TESTCOV
        /RANDOM=INTERCEPT | SUBJECT(Pair_Identifier) COVTYPE(VC).

      SAVE OUTFILE=!filedirRC + !I + !QUOTE('_LID\') +!I + !QUOTE('_ICC for 2000.sav')
        /COMPRESSED.

      OUTPUT SAVE 
       OUTFILE=!filedirRC + !I + !QUOTE('_LID\OUTPUT_') +!I + !QUOTE('_ICC for 2000.spv') 
       LOCK=NO.

      OUTPUT CLOSE *.

      FILTER OFF.
      USE ALL.
      EXECUTE.

      AGGREGATE
        /OUTFILE=* MODE=ADDVARIABLES OVERWRITEVARS=YES
        /BREAK=Pair_Identifier
        /RC_VALUE=MEAN(RC_VALUE).

      SORT CASES BY Pair_Identifier(A).

      IF ($casenum EQ 1 or Pair_Identifier NE lag (Pair_Identifier)) seq =1.
      IF ($casenum  GT 1 and Pair_Identifier EQ lag(Pair_Identifier)) seq = lag(seq) + 1.

      FILTER OFF.
      USE ALL.
      SELECT IF (seq = 1).
      EXECUTE.

COMPUTE SIGN=0.
EXECUTE.
IF  (RC_VALUE >= 0) SIGN=1.
EXECUTE.
FORMATS SIGN (F1.0).
VALUE LABELS SIGN
"0" "Negative RC"
"1" "Positive_Zero RC".

COMPUTE ABS_RC=ABS(RC_VALUE).
EXECUTE.

      SAVE OUTFILE=!filedirRC + !I + !QUOTE('_LID\') +!I + !QUOTE('_LID_RC_FINAL.sav')
       /DROP N_BREAK filter_$ seq
        /COMPRESSED.

DATASET CLOSE ALL.

GET
  FILE=!filedirRC + !I + !QUOTE('_LID\') +!I + !QUOTE('_LID_RC_FINAL.sav'). 


***** SIMPLE RC GRAPHS AND CUSTOM TABLES FOR EACH OF 15 DATASETS SAVED INTO SEPARATE OUTPUT FILES.

FREQUENCIES VARIABLES=TESTLET
  /ORDER=ANALYSIS.

EXAMINE VARIABLES=RC_VALUE
  /PLOT BOXPLOT HISTOGRAM NPPLOT
  /COMPARE GROUPS
  /STATISTICS DESCRIPTIVES EXTREME
  /CINTERVAL 95
  /MISSING LISTWISE
  /NOTOTAL
  /ID=CNT.

EXAMINE VARIABLES=RC_VALUE BY TESTLET
  /PLOT BOXPLOT HISTOGRAM NPPLOT
  /COMPARE GROUPS
  /STATISTICS DESCRIPTIVES EXTREME
  /CINTERVAL 95
  /MISSING LISTWISE
  /NOTOTAL
  /ID=CNT.

USE ALL.
COMPUTE filter_$=(RC_VALUE >= 0.2  | RC_VALUE <= -0.2).
VARIABLE LABELS filter_$ 'RC_VALUE >= 0.2  | RC_VALUE <= -0.2 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=CNT RC_VALUE Pair_Identifier TESTLET MISSING=LISTWISE 
    REPORTMISSING=NO
/GRAPHSPEC SOURCE=GPLFILE(!filedirRC+!QUOTE('FOLDER_TO_KEEP\RC_MORE_LESS_0.2.gpl')).
EXECUTE.

FILTER OFF.
USE ALL.
EXECUTE.

USE ALL.
COMPUTE filter_$=(RC_VALUE  >=  0.2 & TESTLET = 1).
VARIABLE LABELS filter_$ 'RC_VALUE  >=  0.2 & TESTLET = 1 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

* Custom Tables.
CTABLES
  /VLABELS VARIABLES=CNT TESTLET_1 RC_VALUE DISPLAY=LABEL
  /TABLE CNT [C] BY TESTLET_1 [C] > RC_VALUE [S][COUNT F40.0]
  /CATEGORIES VARIABLES=CNT TESTLET_1 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER.

* Custom Tables.
CTABLES
  /VLABELS VARIABLES=Pair_Identifier RC_VALUE DISPLAY=LABEL
  /TABLE Pair_Identifier [C] BY RC_VALUE [S][COUNT F40.0, MEAN, MAXIMUM]
  /CATEGORIES VARIABLES=Pair_Identifier ORDER=A KEY=VALUE EMPTY=EXCLUDE.

FILTER OFF.
USE ALL.
EXECUTE.

USE ALL.
COMPUTE filter_$=(RC_VALUE  >=  0.2 & TESTLET = 0).
VARIABLE LABELS filter_$ 'RC_VALUE  >=  0.2 & TESTLET = 0 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

* Custom Tables.
CTABLES
  /VLABELS VARIABLES=CNT TESTLET_1 RC_VALUE DISPLAY=LABEL
  /TABLE CNT [C] BY TESTLET_1 [C] > RC_VALUE [S][COUNT F40.0]
  /CATEGORIES VARIABLES=CNT TESTLET_1 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER.

* Custom Tables.
CTABLES
  /VLABELS VARIABLES=Pair_Identifier RC_VALUE DISPLAY=LABEL
  /TABLE Pair_Identifier [C] BY RC_VALUE [S][COUNT F40.0, MEAN, MAXIMUM]
  /CATEGORIES VARIABLES=Pair_Identifier ORDER=A KEY=VALUE EMPTY=EXCLUDE.

FILTER OFF.
USE ALL.
EXECUTE.

OUTPUT SAVE 
 OUTFILE=!filedirRC + !I + !QUOTE('_LID\OUTPUT_') +!I + !QUOTE('_LID_RC_FINAL.spv') 
 LOCK=NO.

OUTPUT CLOSE *.

	!DOEnd.
!ENDDEFINE.

************************ COMBINE ALL 15 RC FINAL DATASETS INTO ONE.
************************ MATCH THE FINAL RC DATA WITH ITEM CHARACTERISTICS EXTRACTED FROM THE TECHNICAL MANUALS.

DEFINE MERGE (	WAVE_CD= !charend('/') ).


DATASET CLOSE ALL.

GET
  FILE=!filedirRC+ !QUOTE('FOLDER_TO_KEEP\LID_RC_FINAL_ALL15_TEMPLATE.sav'). 
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (CNT="YYY").
EXECUTE.

	!DO !N !In(!wave_cd).

ADD FILES /FILE=*
  /FILE=!filedirRC + !N + !QUOTE('_LID\') +!N + !QUOTE('_LID_RC_FINAL.sav'). 
EXECUTE.

	!DOEnd.

SAVE OUTFILE=!filedirRC+ !QUOTE('FOLDER_TO_KEEP\LID_RC_FINAL_ALL15_DONE.sav')
  /DROP=CNT_1 Index1 id ID1 SPACE
  /COMPRESSED.

DATASET CLOSE ALL.

GET
  FILE=!filedirRC+ !QUOTE('FOLDER_TO_KEEP\LID_RC_FINAL_ALL15_DONE.sav'). 
EXECUTE.

STRING  OTHER_LID_ID_A (A20).
COMPUTE OTHER_LID_ID_A=CONCAT(YEAR,ITEM_A).
EXECUTE.

STRING  OTHER_LID_ID_B (A20).
COMPUTE OTHER_LID_ID_B=CONCAT(YEAR,ITEM_B).
EXECUTE.

COMPUTE ORDER_ID_ALL=$CASENUM.
EXECUTE.

FORMATS ORDER_ID_ALL (F20.0).

************************ TO MERGE RESIDUAL CORRELATION DATA WITH ITEM EXTRA INFO FROM THE TECHNICAL MANUALS  - INVESTIGATE OTHER LID.

SORT CASES BY OTHER_LID_ID_A(A).

STAR JOIN
  /SELECT t0.ITEM_B, t0.Sample, t0.ITEM_A, t0.RC_VALUE, t0.TESTLET_1, t0.TESTLET_2, t0.TESTLET, 
    t0.ORDER_ID,  t0.ORDER_ID_ALL,  t0.YEAR, t0.DOMAIN, t0.COUNTRY, t0.CNT, t0.SIGN, t0.ABS_RC, t0.Pair_Identifier, 
    t0.Items, t0.OTHER_LID_ID_B, t1.BINARY_ITEM_A, t1.ORDER_ID_A, t1.YEAR_INTRODUCED_A, 
    t1.YEAR_TESTED_A, t1.NR_WAVES_USED_A, t1.NR_ITEMS_TESTLET_A, t1.ITEM_A_TM, t1.ITEM_NAME_A, 
    t1.SOURCE_A, t1.LANGUAGE_SUBMITTED_A, t1.SCALE_A, t1.CLUSTER_A, t1.INT_PERCENT_CORRECT_A, 
    t1.SE_PERCENT_CORRECT_A, t1.INT_IRT_DIFFICULTY_A, t1.COG_DOMAIN_A, t1.Item_Format_2012_A, 
    t1.Content_M_2012_A, t1.Context_M_2012_A, t1.Process_M_2012_A, t1.Situation_R_2012_A, 
    t1.Scale_Text_Format_R_2012_A, t1.Scale_Text_Type_R_2012_A, t1.Aspect_R_2012_A, 
    t1.Application_Area_S_2012_A, t1.Item_Focus_2012_A, t1.Competency_S_2012_A
  /FROM * AS t0
  /JOIN !filedirRC+!QUOTE('FOLDER_TO_KEEP\TECHNICAL_MANUALS_OTHER LID CAUSES.sav') AS t1
    ON t0.OTHER_LID_ID_A=t1.OTHER_LID_ID_A
  /OUTFILE FILE=*.

SORT CASES BY OTHER_LID_ID_B(A).

STAR JOIN
  /SELECT t0.OTHER_LID_ID_A, t0.ITEM_B, t0.Sample, t0.ITEM_A, t0.RC_VALUE, t0.TESTLET_1, 
    t0.TESTLET_2, t0.TESTLET, t0.ORDER_ID, t0.ORDER_ID_ALL, t0.YEAR, t0.DOMAIN, t0.COUNTRY, t0.CNT, t0.SIGN, t0.ABS_RC, 
    t0.Pair_Identifier, t0.Items, t0.BINARY_ITEM_A, t0.ORDER_ID_A, t0.YEAR_INTRODUCED_A, 
    t0.YEAR_TESTED_A, t0.NR_WAVES_USED_A, t0.NR_ITEMS_TESTLET_A, t0.ITEM_A_TM, t0.ITEM_NAME_A, 
    t0.SOURCE_A, t0.LANGUAGE_SUBMITTED_A, t0.SCALE_A, t0.CLUSTER_A, t0.INT_PERCENT_CORRECT_A, 
    t0.SE_PERCENT_CORRECT_A, t0.INT_IRT_DIFFICULTY_A, t0.COG_DOMAIN_A, t0.Item_Format_2012_A, 
    t0.Content_M_2012_A, t0.Context_M_2012_A, t0.Process_M_2012_A, t0.Situation_R_2012_A, 
    t0.Scale_Text_Format_R_2012_A, t0.Scale_Text_Type_R_2012_A, t0.Aspect_R_2012_A, 
    t0.Application_Area_S_2012_A, t0.Item_Focus_2012_A, t0.Competency_S_2012_A, t1.BINARY_ITEM_B, 
    t1.ORDER_ID_B, t1.YEAR_INTRODUCED_B, t1.YEAR_TESTED_B, t1.NR_WAVES_USED_B, t1.NR_ITEMS_TESTLET_B, 
    t1.ITEM_B_TM, t1.ITEM_NAME_B, t1.SOURCE_B, t1.LANGUAGE_SUBMITTED_B, t1.SCALE_B, t1.CLUSTER_B, 
    t1.INT_PERCENT_CORRECT_B, t1.SE_PERCENT_CORRECT_B, t1.INT_IRT_DIFFICULTY_B, t1.COG_DOMAIN_B, 
    t1.Item_Format_2012_B, t1.Content_M_2012_B, t1.Context_M_2012_B, t1.Process_M_2012_B, 
    t1.Situation_R_2012_B, t1.Scale_Text_Format_R_2012_B, t1.Scale_Text_Type_R_2012_B, 
    t1.Aspect_R_2012_B, t1.Application_Area_S_2012_B, t1.Item_Focus_2012_B, t1.Competency_S_2012_B
  /FROM * AS t0
  /JOIN !filedirRC+!QUOTE('FOLDER_TO_KEEP\TECHNICAL_MANUALS_OTHER LID CAUSES.sav') AS t1
    ON t0.OTHER_LID_ID_B=t1.OTHER_LID_ID_B
  /OUTFILE FILE=*.

SORT CASES BY ORDER_ID_ALL(A).


************************ DIFFERENCE BETWEEN PAIR OF ITEMS FOR STRING VARIABLES  - MACRO TO BE CALLED FROM WITHIN ANOTHER MACRO.

STRING_DIFFERENCE  Variables =Application_Area_S_2012 Aspect_R_2012 CLUSTER Competency_S_2012
Content_M_2012 Context_M_2012 Item_Focus_2012 Item_Format_2012 LANGUAGE_SUBMITTED Process_M_2012
SCALE Scale_Text_Format_R_2012 Scale_Text_Type_R_2012 Situation_R_2012 SOURCE.

COMPUTE INT_PERCENT_CORRECT_AB_DIF=ABS(INT_PERCENT_CORRECT_A-INT_PERCENT_CORRECT_B).
EXECUTE.

COMPUTE INT_IRT_DIFFICULTY_AB_DIF=ABS(INT_IRT_DIFFICULTY_A-INT_IRT_DIFFICULTY_B).
EXECUTE.

COMPUTE SE_PERCENT_AB_DIF=ABS(SE_PERCENT_CORRECT_A-SE_PERCENT_CORRECT_B).
EXECUTE.

COMPUTE BINARY_ITEM_AB_DIF=0.
EXECUTE.
IF  (BINARY_ITEM_A = BINARY_ITEM_B)  BINARY_ITEM_AB_DIF=1.
EXECUTE.
FORMATS  BINARY_ITEM_AB_DIF (F1.0).
VALUE LABELS  BINARY_ITEM_AB_DIF
"0" "NOT AGREE"
"1" "AGREE".

COMPUTE YEAR_INTRODUCED_AB_DIF=ABS(YEAR_INTRODUCED_A-YEAR_INTRODUCED_B).
EXECUTE.
FORMATS  YEAR_INTRODUCED_AB_DIF (F2.0).

COMPUTE NR_WAVES_USED_AB_DIF=ABS(NR_WAVES_USED_A-NR_WAVES_USED_B).
EXECUTE.
FORMATS  NR_WAVES_USED_AB_DIF (F2.0).

COMPUTE NR_ITEMS_TESTLET_AB_DIF=ABS(NR_ITEMS_TESTLET_A-NR_ITEMS_TESTLET_B).
EXECUTE.
FORMATS  NR_ITEMS_TESTLET_AB_DIF (F2.0).

STRING  SPACE (A1).
COMPUTE SPACE="_".
EXECUTE.

STRING  TOTAL_Pair_Identifier (A40).
COMPUTE TOTAL_Pair_Identifier=CONCAT(YEAR,SPACE,DOMAIN,SPACE,COUNTRY,SPACE,ITEM_A,SPACE,ITEM_B).
EXECUTE.

RECODE YEAR (CONVERT) ('2000'=2000) ('2003'=2003) ('2006'=2006) ('2009'=2009) ('2012'=2012) INTO 
    YEAR_N.
EXECUTE.
FORMATS  YEAR_N (F4.0).
VARIABLE LEVEL YEAR_N (NOMINAL).
EXECUTE.

SAVE OUTFILE= !filedirRC+ !QUOTE('FOLDER_TO_KEEP\LID_RC_FINAL_ALL15_DONE_FINAL.sav') 
  /COMPRESSED.

DATASET CLOSE ALL.

GET
  FILE=!filedirRC+ !QUOTE('FOLDER_TO_KEEP\LID_RC_FINAL_ALL15_DONE_FINAL.sav').
EXECUTE.

!ENDDEFINE.


************************  MACRO THAT EXTRACTS AND ANALYSE THE WARNINGS FROM THE MPLUS OUTPUTS.

DEFINE WAR (	WAVE_CD= !charend('/') ).

	!DO !I !In(!wave_cd).

DATASET CLOSE ALL.

GET
  FILE=!filedirMAIN + !I + !QUOTE('_MAIN\') +!I + !QUOTE('_ALL.sav').
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (Warning=1).
EXECUTE.

SAVE OUTFILE=!filedirWARN + !I + !QUOTE('_WARNINGS\') +!I + !QUOTE('_WARNINGS.sav')
  /DROP=V1 V14 V15 V16 V17 V18 V19 V20 V21 V22 ID1 ID2 RC MI 
  /COMPRESSED.

	   !DOEnd.

DATASET CLOSE ALL.

GET
  FILE=!filedirWARN + !QUOTE('ALL15_WARNINGS_TEMPLATE.sav').
EXECUTE.

	!DO !I !In(!wave_cd).

ADD FILES /FILE=*
  /FILE=!filedirWARN + !I + !QUOTE('_WARNINGS\') +!I + !QUOTE('_WARNINGS.sav').
EXECUTE.

	   !DOEnd.

SORT VARIABLES BY NAME (A).

COMPUTE ORDER_ID=$CASENUM.
EXECUTE.

SAVE OUTFILE=!filedirWARN + !QUOTE('ALL15_WARNINGS.sav')
  /COMPRESSED.


STRING  ITEM1_A (A10).
IF  (TYPE_Warning=5) ITEM1_A=RTRIM(V5,'.').
EXECUTE.

IF  (TYPE_Warning=4) ITEM1_A=V8.
EXECUTE.

IF  (TYPE_Warning=3 | TYPE_Warning=2  | TYPE_Warning=1) ITEM1_A=V7.
EXECUTE.

STRING  ITEM2_A (A10).
IF  (TYPE_Warning=5) ITEM2_A=RTRIM(V5,'.').
EXECUTE.

IF  (TYPE_Warning=4) ITEM2_A=RTRIM(V10,'.').
EXECUTE.

IF  (TYPE_Warning=3 | TYPE_Warning=2  | TYPE_Warning=1) ITEM2_A=V9.
EXECUTE.

STRING  ITEM1_B (A10).
COMPUTE ITEM1_B=ITEM2_A.
EXECUTE.

STRING  ITEM2_B (A10).
COMPUTE ITEM2_B=ITEM1_A.
EXECUTE.

SAVE OUTFILE=!filedirWARN + !QUOTE('ALL15_WARNINGS_SHORT.sav')
 /DROP CNT_1 Warning V2 V3 V4 V5 V6 V7 V8 V9 V10 V11 V12 V12 V13
  /COMPRESSED.

DATASET CLOSE ALL.

GET
  FILE=!filedirWARN + !QUOTE('ALL15_WARNINGS_SHORT.sav').
EXECUTE.

VARSTOCASES
  /MAKE ITEM1 FROM ITEM1_A ITEM1_B
  /MAKE ITEM2 FROM ITEM2_A ITEM2_B
  /INDEX=Original_ORDER(2) 
  /KEEP=ORDER_ID CNT COUNTRY DOMAIN Items Sample TYPE_Warning YEAR
  /NULL=KEEP.


STRING  SPACE (A1).
COMPUTE SPACE="_".
EXECUTE.

STRING  Pair_Identifier (A20).
COMPUTE Pair_Identifier=CONCAT(ITEM1,SPACE,ITEM2).
EXECUTE.

STRING  TOTAL_Pair_Identifier (A40).
COMPUTE TOTAL_Pair_Identifier=CONCAT(YEAR,SPACE,DOMAIN,SPACE,COUNTRY,SPACE,ITEM1,SPACE,ITEM2).
EXECUTE.

SAVE OUTFILE=!filedirWARN + !QUOTE('ALL15_WARNINGS_FINAL.sav')
  /COMPRESSED.

DATASET CLOSE ALL.

GET
  FILE=!filedirWARN + !QUOTE('ALL15_WARNINGS_FINAL.sav').
EXECUTE.

!ENDDEFINE.

* MACRO TO PREPARE FILES FOR Qqraph.

DEFINE RCQgraph (	WAVE_CD= !charend('/') ).

***** LOOP STARTS HERE - USES THE DATAFILES FROM ALL RC_FINAL FILES.

	!DO !I !In(!wave_cd).

DATASET CLOSE ALL.

GET
  FILE=!filedirRC + !I + !QUOTE('_LID\') +!I + !QUOTE('_LID_RC_FINAL.sav'). 

SAVE OUTFILE=!filedirQgraph + !I + !QUOTE('_Qgraph\') +!I + !QUOTE('_Qgraph.sav')
  /DROP=id ID1 CNT_1 Sample Items Index1 TESTLET_1 TESTLET_2 TESTLET YEAR DOMAIN COUNTRY CNT ORDER_ID SIGN ABS_RC SPACE Pair_Identifier 
  /COMPRESSED.

DATASET CLOSE ALL.

GET
  FILE=!filedirQgraph + !I + !QUOTE('_Qgraph\') +!I + !QUOTE('_Qgraph.sav') 

SORT VARIABLES BY NAME (A).

SAVE TRANSLATE OUTFILE=!filedirQgraph + !I + !QUOTE('_Qgraph\') +!I + !QUOTE('_Qgraph.csv') 
  /TYPE=CSV
  /ENCODING='UTF8'
  /MAP
  /REPLACE
  /FIELDNAMES
  /CELLS=VALUES.

DATASET CLOSE ALL.

GET
  FILE=!filedirRC + !I + !QUOTE('_LID\') +!I + !QUOTE('_LID_RC_FINAL.sav'). 

VARSTOCASES
  /MAKE trans1 FROM ITEM_A ITEM_B
  /INDEX=Index1(trans1) 
  /KEEP=
  /NULL=KEEP.

STRING  TESTLET_1_2 (A8).
COMPUTE TESTLET_1_2=STRUNC(trans1,4).
EXECUTE.

AGGREGATE
  /OUTFILE=!filedirQgraph + !I + !QUOTE('_Qgraph\') +!I + !QUOTE('_Qgraph_AGG.sav')
  /BREAK=trans1
  /TESTLET_1_2_first=FIRST(TESTLET_1_2).

DATASET CLOSE ALL.

GET
  FILE=!filedirQgraph + !I + !QUOTE('_Qgraph\') +!I + !QUOTE('_Qgraph_AGG.sav')

RENAME VARIABLES (TESTLET_1_2_first=Testlet).
RENAME VARIABLES (trans1=Item).

SAVE TRANSLATE OUTFILE=!filedirQgraph + !I + !QUOTE('_Qgraph\') +!I + !QUOTE('_Qgraph_groups.csv') 
  /TYPE=CSV
  /ENCODING='UTF8'
  /MAP
  /REPLACE
  /FIELDNAMES
  /CELLS=VALUES.

	!DOEnd.
!ENDDEFINE.


************************ CALLING MACRO. 

AGG_MPLUS  WAVE_CD =
'2000_R' '2000_S' '2000_M' 
'2003_R' '2003_S' '2003_M' 
'2006_R' '2006_S' '2006_M' 
'2009_R' '2009_S' '2009_M' 
'2012_R' '2012_S' '2012_M' .


************************ CALLING MACRO. 

RC15FILES  WAVE_CD =
'2000_R' '2000_S' '2000_M' 
'2003_R' '2003_S' '2003_M' 
'2006_R' '2006_S' '2006_M' 
'2009_R' '2009_S' '2009_M' 
'2012_R' '2012_S' '2012_M' .

************************ CALLING MACRO. 

MERGE  WAVE_CD =
'2000_R' '2000_S' '2000_M' 
'2003_R' '2003_S' '2003_M' 
'2006_R' '2006_S' '2006_M' 
'2009_R' '2009_S' '2009_M' 
'2012_R' '2012_S' '2012_M' .

************************ CALLING MACRO.

WAR  WAVE_CD =
'2000_R' '2000_S' '2000_M' 
'2003_R' '2003_S' '2003_M' 
'2006_R' '2006_S' '2006_M' 
'2009_R' '2009_S' '2009_M' 
'2012_R' '2012_S' '2012_M' .

************************ CALLING MACRO.

RCQgraph  WAVE_CD =
'2000_R' '2000_S' '2000_M' 
'2003_R' '2003_S' '2003_M' 
'2006_R' '2006_S' '2006_M' 
'2009_R' '2009_S' '2009_M' 
'2012_R' '2012_S' '2012_M' .


